/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.base.Core;
import org.adempiere.base.event.EventManager;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTable;
import org.compiere.model.MUserDefWin;
import org.compiere.model.MWindow;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_AD_RecentItem;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.idempiere.cache.ImmutablePOCache;
import org.idempiere.cache.ImmutablePOSupport;
import org.idempiere.distributed.IMessageService;
import org.idempiere.distributed.ITopic;
import org.osgi.service.event.Event;

public class MRecentItem
extends X_AD_RecentItem
implements ImmutablePOSupport {
    private static final long serialVersionUID = 6284848250030738141L;
    public static final String ON_RECENT_ITEM_CHANGED_TOPIC = "onRecentItemChanged";
    private static ImmutablePOCache<String, MRecentItem> s_cache = new ImmutablePOCache("AD_RecentItem", 10);
    private static CLogger s_log = CLogger.getCLogger(MRecentItem.class);
    private String m_label;

    public MRecentItem(Properties ctx, String AD_RecentItem_UU, String trxName) {
        super(ctx, AD_RecentItem_UU, trxName);
    }

    public MRecentItem(Properties ctx, int AD_RecentItem_ID, String trxName) {
        super(ctx, AD_RecentItem_ID, trxName);
    }

    private static String getCacheKey(int AD_RecentItem_ID, Properties ctx) {
        return AD_RecentItem_ID + "|" + Env.getAD_Language(ctx);
    }

    public MRecentItem(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MRecentItem(MRecentItem copy) {
        this(Env.getCtx(), copy);
    }

    public MRecentItem(Properties ctx, MRecentItem copy) {
        this(ctx, copy, null);
    }

    public MRecentItem(Properties ctx, MRecentItem copy, String trxName) {
        this(ctx, 0, trxName);
        this.copyPO(copy);
        this.m_label = copy.m_label;
    }

    public static synchronized MRecentItem get(Properties ctx, int AD_RecentItem_ID) {
        String ii = MRecentItem.getCacheKey(AD_RecentItem_ID, ctx);
        MRecentItem ri = s_cache.get(ctx, ii, e -> new MRecentItem(ctx, (MRecentItem)e));
        if (ri == null) {
            ri = new MRecentItem(ctx, AD_RecentItem_ID, null);
            if (ri.get_ID() == AD_RecentItem_ID) {
                s_cache.put(ii, ri, e -> new MRecentItem(Env.getCtx(), (MRecentItem)e));
                return ri;
            }
            return null;
        }
        return ri;
    }

    public static synchronized MRecentItem getCopy(Properties ctx, int AD_RecentItem_ID, String trxName) {
        MRecentItem ri = MRecentItem.get(ctx, AD_RecentItem_ID);
        if (ri != null) {
            ri = new MRecentItem(ctx, ri, trxName);
        }
        return ri;
    }

    public static synchronized MRecentItem get(Properties ctx, int AD_Table_ID, int Record_ID, String Record_UU, int AD_User_ID) {
        MRecentItem retValue2;
        for (MRecentItem retValue2 : s_cache.values()) {
            if (retValue2.getAD_Table_ID() != AD_Table_ID || (retValue2.getRecord_UU() == null || !retValue2.getRecord_UU().equals(Record_UU)) && retValue2.getRecord_ID() != Record_ID || retValue2.getAD_User_ID() != AD_User_ID || retValue2.getAD_Client_ID() != Env.getAD_Client_ID(ctx) || !Env.getAD_Language(ctx).equals(Env.getAD_Language(retValue2.getCtx()))) continue;
            return retValue2;
        }
        retValue2 = Record_UU != null ? (MRecentItem)new Query(ctx, "AD_RecentItem", "AD_Table_ID=? AND Record_UU=? AND AD_User_ID=? AND AD_Client_ID=?", null).setParameters(AD_Table_ID, Record_UU, AD_User_ID, Env.getAD_Client_ID(ctx)).first() : (MRecentItem)new Query(ctx, "AD_RecentItem", "AD_Table_ID=? AND Record_ID=? AND AD_User_ID=? AND AD_Client_ID=?", null).setParameters(AD_Table_ID, Record_ID, AD_User_ID, Env.getAD_Client_ID(ctx)).first();
        if (retValue2 != null) {
            String key = MRecentItem.getCacheKey(retValue2.getAD_RecentItem_ID(), ctx);
            s_cache.put(key, retValue2, e -> new MRecentItem(Env.getCtx(), (MRecentItem)e));
        }
        return retValue2;
    }

    public static void addModifiedField(Properties ctx, int AD_Table_ID, int Record_ID, String Record_UU, int AD_User_ID, int AD_Role_ID, int AD_Window_ID, int AD_Tab_ID) {
        int maxri = MSysConfig.getIntValue("RecentItems_MaxSaved", 50, Env.getAD_Client_ID(ctx));
        if (maxri <= 0) {
            return;
        }
        MRecentItem ric = MRecentItem.get(ctx, AD_Table_ID, Record_ID, Record_UU, AD_User_ID);
        if (ric == null) {
            MRecentItem ri = new MRecentItem(ctx, 0, null);
            ri.setAD_Table_ID(AD_Table_ID);
            ri.setRecord_ID(Record_ID);
            ri.setRecord_UU(Record_UU);
            ri.setAD_User_ID(AD_User_ID);
            ri.setAD_Role_ID(AD_Role_ID);
            ri.setAD_Window_ID(AD_Window_ID);
            ri.setAD_Tab_ID(AD_Tab_ID);
            ri.saveCrossTenantSafeEx();
        } else if (ric.getAD_Role_ID() != AD_Role_ID || ric.getAD_Window_ID() != AD_Window_ID || ric.getAD_Tab_ID() != AD_Tab_ID) {
            MRecentItem ri = MRecentItem.getCopy(ctx, ric.getAD_RecentItem_ID(), null);
            ri.setAD_Role_ID(AD_Role_ID);
            ri.setAD_Window_ID(AD_Window_ID);
            ri.setAD_Tab_ID(AD_Tab_ID);
            ri.saveCrossTenantSafeEx();
        } else {
            DB.executeUpdateEx("UPDATE AD_RecentItem SET Updated=getDate() WHERE AD_RecentItem_ID=?", new Object[]{ric.getAD_RecentItem_ID()}, null);
        }
        MRecentItem.publishChangedEvent(AD_User_ID);
    }

    public static void publishChangedEvent(int AD_User_ID) {
        IMessageService service = Core.getMessageService();
        if (service != null) {
            ITopic<Integer> topic = service.getTopic(ON_RECENT_ITEM_CHANGED_TOPIC);
            topic.publish(AD_User_ID);
        } else {
            MRecentItem.postOnChangedEvent(AD_User_ID);
        }
    }

    public static void postOnChangedEvent(int AD_User_ID) {
        HashMap<String, Integer> properties = new HashMap<String, Integer>();
        properties.put("AD_User_ID", AD_User_ID);
        Event event = EventManager.newEvent(ON_RECENT_ITEM_CHANGED_TOPIC, properties, true);
        EventManager.getInstance().postEvent(event);
    }

    public static void touchUpdatedRecord(Properties ctx, int AD_Table_ID, int Record_ID, String Record_UU, int AD_User_ID) {
        MRecentItem ri = MRecentItem.get(ctx, AD_Table_ID, Record_ID, Record_UU, AD_User_ID);
        if (ri != null) {
            DB.executeUpdateEx("UPDATE AD_RecentItem SET Updated=getDate() WHERE AD_RecentItem_ID=?", new Object[]{ri.getAD_RecentItem_ID()}, null);
            MRecentItem.deleteExtraRecentItems(ctx, AD_User_ID);
            MRecentItem.publishChangedEvent(AD_User_ID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static void deleteExtraRecentItems(Properties ctx, int AD_User_ID) {
        int[] ids;
        int AD_Client_ID = Env.getAD_Client_ID(ctx);
        int maxri = MSysConfig.getIntValue("RecentItems_MaxSaved", 50, AD_Client_ID);
        if (maxri <= 0) {
            maxri = 50;
        }
        if ((ids = DB.getIDsEx(null, "SELECT AD_RecentItem_ID FROM AD_RecentItem WHERE AD_User_ID=? AND AD_Client_ID=? AND AD_RecentItem_ID NOT IN ( SELECT AD_RecentItem_ID FROM AD_RecentItem WHERE AD_User_ID=? AND AD_Client_ID=? ORDER BY Updated DESC FETCH FIRST ? ROWS ONLY)", AD_User_ID, AD_Client_ID, AD_User_ID, AD_Client_ID, maxri)).length <= 0) return;
        int[] nArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            int id = nArray[n2];
            String ii = MRecentItem.getCacheKey(id, ctx);
            Class<MRecentItem> clazz = MRecentItem.class;
            // MONITORENTER : org.compiere.model.MRecentItem.class
            s_cache.remove(ii);
            // MONITOREXIT : clazz
            ++n2;
        }
        DB.executeUpdateEx("DELETE FROM AD_RecentItem WHERE AD_User_ID=? AND AD_Client_ID=? AND AD_RecentItem_ID NOT IN ( SELECT AD_RecentItem_ID FROM AD_RecentItem WHERE AD_User_ID=? AND AD_Client_ID=? ORDER BY Updated DESC FETCH FIRST ? ROWS ONLY)", new Object[]{AD_User_ID, AD_Client_ID, AD_User_ID, AD_Client_ID, maxri}, null);
    }

    public static List<MRecentItem> getFromUser(Properties ctx, int AD_User_ID) {
        int[] ids = new Query(ctx, "AD_RecentItem", "AD_User_ID=?", null).setOnlyActiveRecords(true).setClient_ID().setParameters(AD_User_ID).setOrderBy("Updated DESC").getIDs();
        ArrayList<MRecentItem> ris = new ArrayList<MRecentItem>();
        int[] nArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            int id = nArray[n2];
            ris.add(MRecentItem.get(ctx, id));
            ++n2;
        }
        return ris;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLabel() {
        if (this.m_label != null) {
            return this.m_label;
        }
        MWindow win = MWindow.get(this.getCtx(), this.getAD_Window_ID());
        MUserDefWin userDef = MUserDefWin.getBestMatch(this.getCtx(), this.getAD_Window_ID());
        String windowName = userDef != null && !Util.isEmpty(userDef.getName()) ? userDef.getName() : win.get_Translation("Name");
        MTable table2 = MTable.get(this.getCtx(), this.getAD_Table_ID());
        PO po = null;
        if (this.getRecord_UU() != null) {
            po = table2.getPOByUU(this.getRecord_UU(), null);
        } else if (this.getRecord_ID() > 0) {
            po = table2.getPO(this.getRecord_ID(), null);
        }
        if (po == null) {
            String ii = MRecentItem.getCacheKey(this.getAD_RecentItem_ID(), this.getCtx());
            Class<MRecentItem> clazz = MRecentItem.class;
            synchronized (MRecentItem.class) {
                s_cache.remove(ii);
                // ** MonitorExit[var7_8] (shouldn't be in output)
                DB.executeUpdateEx("DELETE FROM AD_RecentItem WHERE AD_RecentItem_ID=?", new Object[]{this.getAD_RecentItem_ID()}, null);
                return null;
            }
        }
        String titleLogic = win.getTitleLogic();
        StringBuilder recordIdentifier = new StringBuilder("");
        if (!Util.isEmpty(titleLogic) && !Util.isEmpty(titleLogic = Env.parseVariable(titleLogic, po, null, false))) {
            recordIdentifier.append(" ").append(titleLogic);
        }
        if (recordIdentifier.length() == 0) {
            if (po.get_ColumnIndex("DocumentNo") != -1) {
                recordIdentifier.append(" ").append(po.get_ValueAsString("DocumentNo"));
            }
            if (po.get_ColumnIndex("Value") != -1) {
                recordIdentifier.append(" ").append(po.get_ValueAsString("Value"));
            }
            if (po.get_ColumnIndex("Name") != -1) {
                recordIdentifier.append(" ").append(po.get_ValueAsString("Name"));
            }
            if (recordIdentifier.length() == 0) {
                recordIdentifier.append(" ").append(po.toString());
            }
            if (recordIdentifier.length() == 0) {
                recordIdentifier.append(" [").append(po.get_ID()).append("]");
            }
            if (recordIdentifier.length() == 0) {
                recordIdentifier.append(" [no identifier]");
            }
        }
        this.m_label = windowName + ": " + recordIdentifier.substring(1);
        if (s_log.isLoggable(Level.INFO)) {
            s_log.info(this.m_label);
        }
        return this.m_label;
    }

    public static synchronized void clearLabel(int AD_Table_ID, int Record_ID, String Record_UU) {
        for (MRecentItem retValue : s_cache.values()) {
            if (retValue.getAD_Table_ID() != AD_Table_ID || (Record_ID <= 0 || retValue.getRecord_ID() != Record_ID) && (retValue.getRecord_UU() == null || !retValue.getRecord_UU().equals(Record_UU))) continue;
            retValue.clearLabel();
        }
    }

    private void clearLabel() {
        this.m_label = null;
    }

    @Override
    public MRecentItem markImmutable() {
        if (this.is_Immutable()) {
            return this;
        }
        this.makeImmutable();
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MRecentItem[").append(this.get_ID()).append("]=").append(this.getLabel());
        return sb.toString();
    }
}

